#---------------------------------------------------------------------------
# Copyright 2012 The Open Source Electronic Health Record Agent
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#---------------------------------------------------------------------------
import sys
import time
sys.path = ['C:/Users/contestant/OSEHRA/Dashboards/OSEHRA-Automated-Testing/Python'] + sys.path

from OSEHRAHelper import ConnectToMUMPS,PROMPT
VistA=ConnectToMUMPS("C:/Users/contestant/OSEHRA/Dashboards/OSEHRA-Automated-Testing-build/Testing/Log/SchedulingSetup.log","CACHE","CPM")
if ('' and ''):
  VistA.login('','')
if VistA.type=='cache':
  try:
    VistA.ZN('CPM')
  except IndexError,no_namechange:
    pass
VistA.wait(PROMPT)
#---------------------------------------------------------------------
#- SECTION TO SETUP DEMO VistA SITE -
#---------------------------------------------------------------------
#Initialze FileMan

VistA.write('D ^DINIT')
VistA.wait('Initialize VA FileMan now?')
VistA.write('Yes')
VistA.wait('SITE NAME:')
VistA.write('DEMO.OSEHRA.ORG')
VistA.wait('SITE NUMBER')
VistA.write('6161')
VistA.wait('Do you want to change the MUMPS OPERATING SYSTEM File?')
VistA.write('Yes')
VistA.wait('TYPE OF MUMPS SYSTEM YOU ARE USING')
if VistA.type=='cache':
  VistA.write('CACHE')
else:
  VistA.write('GT.M(UNIX)')
VistA.wait(PROMPT)
#Setup the ZU Routine
VistA.write('D ^ZUSET')
VistA.wait('Rename')
VistA.write('Yes')
VistA.wait(PROMPT)
VistA.write('S DUZ=1 D Q^DI')

#Ensure that the null device is correctly configured.

VistA.wait('Select OPTION:')
VistA.write('1')
VistA.wait('INPUT TO WHAT FILE')
VistA.write('DEVICE')
VistA.wait('EDIT WHICH FIELD')
VistA.write('$I\rSIGN-ON/SYSTEM DEVICE\r')
VistA.wait('NAME:')
VistA.write('NULL\r1')
VistA.wait('//')
if sys.platform=='win32':
  VistA.write('//./nul\rNO\r')
else:
  VistA.write('/dev/null\rNO\r')

#Create and Christen the New Domain
VistA.wait('Select OPTION:')
VistA.write('1')
VistA.wait('INPUT TO WHAT FILE')
VistA.write('DOMAIN\r')
VistA.wait('Select DOMAIN NAME')
VistA.write('DEMO.OSEHRA.ORG\rY\r^\r\r')
VistA.wait(PROMPT)
VistA.write('D CHRISTEN^XMUDCHR')
VistA.wait('Are you sure you want to change the name of this facility?')
VistA.write('Yes')
VistA.wait('Select DOMAIN NAME')
VistA.write('DEMO.OSEHRA.ORG')
VistA.wait('PARENT')
VistA.write('')
VistA.wait('TIME ZONE')
VistA.write(time.strftime('%Z').replace(' Time',''))
index = VistA.multiwait([VistA.prompt,'TIME ZONE'])
if index==1:
  VistA.write('EST')
  VistA.wait(PROMPT)
VistA.IEN('DOMAIN','DEMO.OSEHRA.ORG')
VistA.wait(PROMPT)
VistA.write('S $P(^XWB(8994.1,1,0),"^")=' + VistA.IENumber)
VistA.write('S $P(^XTV(8989.3,1,0),"^")=' + VistA.IENumber)
VistA.getenv('ROU')
VistA.wait(PROMPT)
VistA.write('S DUZ=1 D Q^DI')
VistA.wait('Select OPTION')
VistA.write('UTILITY')
VistA.wait('UTILITY OPTION')
VistA.write('RE')
VistA.wait('MODIFY WHAT FILE')
VistA.write('8989.3\rNO\rY\rY')
VistA.wait('UTILITY OPTION')
VistA.write('RE')
VistA.wait('MODIFY WHAT FILE')
VistA.write('8994.1\rNO\rY\rY\r')
VistA.wait('Select OPTION')

# Set up the proper Box:Volume pair
VistA.write('1')
VistA.wait('INPUT TO WHAT FILE')
VistA.write('14.5\r')
VistA.wait('Select VOLUME SET')
VistA.write('`1')
VistA.wait('VOLUME SET:')
VistA.write('ROU\r\r\r\r\r')
VistA.wait('TASKMAN FILES UCI')
if VistA.type=='cache':
  VistA.write('CPM\r\r\r\r\r\r')
else:
  VistA.write('ROU\r\r\r\r\r\r')

VistA.wait('Select OPTION:')
VistA.write('1')
VistA.wait('INPUT TO WHAT FILE')
VistA.write('14.7')
VistA.wait('ALL//')
VistA.write('')
VistA.wait('Select TASKMAN SITE PARAMETERS BOX-VOLUME PAIR:')
VistA.write('`1')
VistA.wait('//')
VistA.write(VistA.boxvol)
VistA.wait('RESERVED')
VistA.write('^\r')

VistA.wait('Select OPTION')
VistA.write('1')
VistA.wait('INPUT TO WHAT FILE')
VistA.write('HOLIDAY\r1')
VistA.wait('EDIT WHICH FIELD')
VistA.write('')
VistA.wait('Select HOLIDAY DATE')
VistA.write('JUL 4, 2012\rY')
VistA.wait('HOLIDAY NAME')
VistA.write('Independence Day\r')
VistA.wait('Select HOLIDAY DATE')
VistA.write('')

VistA.wait('Select OPTION')
VistA.write('1')
VistA.wait('INPUT TO WHAT FILE')
VistA.write('8994.1\r')
VistA.wait('Select RPC BROKER SITE PARAMETERS DOMAIN NAME')
VistA.write('DEMO.OSEHRA.ORG\r\r\r\r' + VistA.boxvol + '\rY\r\r9210\rY')
if VistA.type=='cache':
  VistA.write('1\r\r1\r')
else:
  VistA.write('1\r\r\r')

VistA.wait('Select OPTION')
VistA.write('1')
VistA.wait('INPUT TO WHAT FILE')
VistA.write('KERNEL SYSTEM PARAMETERS\rVOLUME SET\r\r')
VistA.wait('Select KERNEL SYSTEM PARAMETERS DOMAIN NAME:')
VistA.write('DEMO.OSEHRA.ORG\r\rROU\rY\r500\rN\r\r\r')


# Start TaskMan
VistA.wait(PROMPT)
VistA.write('K')
VistA.wait(PROMPT)
VistA.write('D ^ZTMB')


#Create the System Manager
VistA.wait(PROMPT)
VistA.write('S DUZ=1 D ^XUP')
VistA.wait('Select OPTION NAME')
VistA.write('EVE\r1')
VistA.wait('Select Systems Manager Menu Option:')
VistA.write('USER MANAGEMENT')
VistA.wait('Select User Management Option:')
VistA.write('ADD')
VistA.wait(':')
VistA.write('MANAGER,SYSTEM')
VistA.wait('No//')
VistA.write('Y')
VistA.wait('INITIAL:')
VistA.write('SM')
VistA.wait('SSN:')
VistA.write('000000001')
VistA.wait('SEX:')
VistA.write('M')
VistA.wait('NPI')
VistA.write('')

#TODO: Give XUPROGMODE key
VistA.wait('NAME COMPONENTS')
VistA.write('\r\r\r\r\r^PRIMARY MENU OPTION\rEVE\r1\r^Want to edit ACCESS CODE\rY\rSM1234\rSM1234\r^Want to edit VERIFY CODE\rY\rSM1234!!\rSM1234!!\r^SECONDARY MENU OPTIONS\rOR PARAM COORDINATOR MENU\rY\r\r\r\rTIU IRM MAINTENANCE MENU\rY\r\r\r\rXPAR MENU TOOLS\rY\r\r\r\rDG REGISTER PATIENT\rY\r\r\r\r^MULTIPLE SIGN-ON\r1\r1\r99\r^SERVICE/SECTION\rIRM\r^\rY')
VistA.wait('User Account Access Letter')
VistA.write('NO')
VistA.wait('wish to allocate security keys?')
VistA.write('Y')
VistA.wait('Allocate key')
VistA.write('XUMGR')
VistA.wait('Another key')
VistA.write('XUPROG\r1')
VistA.wait('Another key')
VistA.write('')
VistA.wait('Another holder')
VistA.write('')
VistA.wait('YES//')
VistA.write('')
VistA.wait('mail groups?')
VistA.write('\r')
VistA.wait('Option')
# Set the Listener Starter to run when TaskMan is started
if VistA.type=='cache':
  VistA.write('TASK')
  VistA.wait('Option:')
  VistA.write('SCHED')
  VistA.wait('reschedule:')
  VistA.write('XWB LISTENER STARTER\rY')
  VistA.wait('COMMAND:')
  VistA.write('\r^SPECIAL QUEUEING\rSTARTUP\rS\rE\r\r\r\r')
else:
  VistA.write('\rY')
VistA.wait(PROMPT)
VistA.IEN('NEW PERSON','MANAGER,SYSTEM')
VistA.wait(PROMPT)
VistA.write('S DUZ=' + VistA.IENumber + ' S $P(^VA(200,DUZ,0),"^",4)="@"')

 #Open FileMan and start by creating the VistA Health Care institution

VistA.wait(PROMPT)
VistA.write('S DUZ=1 S XUMF=1 D Q^DI')
VistA.wait('OPTION:')
VistA.write('1')
VistA.wait('INPUT TO WHAT FILE:')
VistA.write('4')
VistA.wait('EDIT WHICH FIELD')
VistA.write('STATION NUMBER')
VistA.wait('THEN EDIT FIELD')
VistA.write('')
VistA.wait('Select INSTITUTION NAME:')
VistA.write('VISTA HEALTH CARE')
VistA.wait('Are you adding')
VistA.write('Y')
VistA.wait('STATION NUMBER:')
VistA.write('6100')
VistA.wait('Select INSTITUTION NAME:')
VistA.write('')

#Next create the Medical Center Division of the VistA Health Care institution

VistA.wait('Select OPTION:')
VistA.write('1')
VistA.wait('INPUT TO WHAT FILE:')
VistA.write('40.8')
VistA.wait('EDIT WHICH FIELD')
VistA.write('FACILITY NUMBER')
VistA.wait('THEN EDIT FIELD')
VistA.write('INSTITUTION FILE POINTER')
VistA.wait('THEN EDIT FIELD')
VistA.write('')
VistA.wait('DIVISION NAME')
VistA.write('VISTA MEDICAL CENTER')
VistA.wait('Are you adding')
VistA.write('Y')
VistA.wait('MEDICAL CENTER DIVISION NUM:')
VistA.write('')
VistA.wait('FACILITY NUMBER')
VistA.write('6101')
VistA.write('')
VistA.wait('INSTITUTION FILE POINTER')
VistA.write('6100')
VistA.write('\r')

#Change the accession number of the Chemistry area
VistA.wait(PROMPT)
VistA.write('D Q^DI')
VistA.wait('OPTION')
VistA.write('1')
VistA.wait('INPUT TO WHAT FILE')
VistA.write('ACCESSION\r1')
VistA.wait('EDIT WHICH FIELD')
VistA.write('.4\r')
VistA.wait('Select ACCESSION AREA')
VistA.write('CHEMISTRY')
VistA.wait('NUMERIC IDENTIFIER')
VistA.write('CH\r')

#Change the STREPTOZYME test to be accessioned through the chem area and the Vista Health Care institution
VistA.wait('OPTION')
VistA.write('1')
VistA.wait('INPUT TO WHAT FILE')
VistA.write('LABORATORY TEST')
VistA.wait('EDIT WHICH FIELD')
VistA.write('ACCESSION AREA\r\r')
VistA.wait('Select LABORATORY TEST NAME')
VistA.write('STREPTOZYME')
VistA.wait('Select INSTITUTION')
VistA.write('VISTA HEALTH CARE')
VistA.wait('ACCESSION AREA')
VistA.write('CHEMISTRY\r')

#Change the Package Prefix of the ONCE scheudle to be used by the Laboratory

VistA.wait('OPTION')
VistA.write('1')
VistA.wait('INPUT TO WHAT FILE')
VistA.write('ADMINISTRATION SCHEDULE')
VistA.wait('EDIT WHICH FIELD')
VistA.write('PACKAGE PREFIX\r')
VistA.wait('Select ADMINISTRATION SCHEDULE NAME')
VistA.write('ONCE\rLR\r\r')

#Register the Vitals DLL and GUI Versions within the XPAR Menu

VistA.wait(PROMPT)
VistA.write('S GMVDLL=\"GMV_VITALSVIEWENTER.DLL:v. 08/11/09 15:00\"')
VistA.wait(PROMPT)
VistA.write('D EN^XPAR(\"SYS\",\"GMV DLL VERSION\",GMVDLL,1)')
VistA.wait(PROMPT)
VistA.write('S GMVDLL=\"GMV_VITALSVIEWENTER.DLL:v. 01/21/11 12:52\"')
VistA.wait(PROMPT)
VistA.write('D EN^XPAR(\"SYS\",\"GMV DLL VERSION\",GMVDLL,1)')
VistA.wait(PROMPT)
VistA.write('S GMVGUI=\"VITALSMANAGER.EXE:5.0.26.1\"')
VistA.wait(PROMPT)
VistA.write('D EN^XPAR(\"SYS\",\"GMV GUI VERSION\",GMVGUI,1)')


# Sign into the ZU menu as the System,Manager and start the TCP listeneer

VistA.wait(PROMPT)
VistA.write('D ^ZU')
VistA.wait('ACCESS CODE:')
VistA.write('SM1234')
VistA.wait('VERIFY CODE:')
VistA.write('SM1234!!')
VistA.wait('verify code:')
VistA.write('SM1234!!')
VistA.wait('VERIFY CODE:')
VistA.write('SM12345!!')
VistA.wait('right:')
VistA.write('SM12345!!')
VistA.wait('TYPE NAME:')
VistA.write('')

#Enter the Doctor Robert Alexander
VistA.write('USER MANAGEMENT')
VistA.wait('Select User Management Option')
VistA.write('ADD')
VistA.wait('name')
VistA.write('ALEXANDER,ROBERT\rY')
VistA.wait('INITIAL:')
VistA.write('RA')
VistA.wait('SSN:')
VistA.write('000000029')
VistA.wait('SEX:')
VistA.write('M')
VistA.wait('NPI')
VistA.write('')
VistA.wait('NAME COMPONENTS')
VistA.write('\r\r\r\r\r^PRIMARY MENU OPTION\rXUCOR\r^SECONDARY MENU OPTIONS\rOR CPRS GUI CHART\rY\r\r\r\rGMV V/M GUI\rY\r\r\r\r^Want to edit ACCESS CODE\rY\rfakedoc1\rfakedoc1\r^Want to edit VERIFY CODE\rY\r2Doc!@#$\r2Doc!@#$\rVISTA HEALTH CARE\rY\r\r\r\r\r^SERVICE/SECTION\rIRM\r^Language\r\r767\rY\rY\rT-1\r\r^RESTRICT PATIENT SELECTION\r0\r\rCOR\rY\rT-1\r\r^MULTIPLE SIGN-ON\r1\r1\r99\r^\rE\rY')
VistA.wait('User Account Access Letter')
VistA.write('NO')
VistA.wait('wish to allocate security keys?')
VistA.write('Y')
VistA.wait('Allocate key')
VistA.write('PROVIDER\r1')
VistA.wait('Another key')
VistA.write('GMV MANAGER')
VistA.wait('Another key')
VistA.write('LRLAB')
VistA.wait('Another key')
VistA.write('LRVERIFY')
VistA.wait('Another key')
VistA.write('ORES\r')
VistA.wait('Another holder')
VistA.write('')
VistA.wait('Do you wish to proceed')
VistA.write('Yes')
VistA.wait('add this user to mail groups')
VistA.write('NO')

#Enter the Nurse Mary Smith
VistA.wait('Select User Management Option')
VistA.write('ADD')
VistA.wait('name')
VistA.write('SMITH,MARY\rY')
VistA.wait('INITIAL:')
VistA.write('MS')
VistA.wait('SSN:')
VistA.write('000000030')
VistA.wait('SEX:')
VistA.write('F')
VistA.wait('NPI')
VistA.write('')
VistA.wait('NAME COMPONENTS')
VistA.write('\r\r\r\r\r^PRIMARY MENU OPTION\rXUCOR\r^SECONDARY MENU OPTIONS\rOR CPRS GUI CHART\rY\r\r\r\rGMV V/M GUI\rY\r\r\r\r^Want to edit ACCESS CODE\rY\rfakenurse1\rfakenurse1\r^Want to edit VERIFY CODE\rY\r2Nur!@#$\r2Nur!@#$\rVISTA HEALTH CARE\rY\r\r\r\r\r^SERVICE/SECTION\rIRM\r^Language\r\r289\rY\rY\rT-1\r\r^RESTRICT PATIENT SELECTION\r0\r\rCOR\rY\rT-1\r\r^\rE\rY')
VistA.wait('User Account Access Letter')
VistA.write('NO')
VistA.wait('wish to allocate security keys?')
VistA.write('Y')
VistA.wait('Allocate key')
VistA.write('PROVIDER\r1')
VistA.wait('Another key')
VistA.write('ORELSE\r')
VistA.wait('Another holder')
VistA.write('')
VistA.wait('Do you wish to proceed')
VistA.write('Yes')
VistA.wait('add this user to mail groups')
VistA.write('NO\r')

#Create the first patient named "David Carter Jr')
#TODO: Enter patient as a Clerk, not System Manager

VistA.wait('Menu Option:')
VistA.write('Register a Patient')
VistA.wait('PATIENT NAME')
VistA.write('Carter,David Jr\rY')
VistA.wait('SEX')
VistA.write('M')
VistA.wait('DATE OF BIRTH')
VistA.write('03/02/2001')
VistA.wait('SOCIAL SECURITY NUMBER')
VistA.write('000000112')
VistA.wait('TYPE')
VistA.write('NON-VETERAN')
VistA.wait('PATIENT VETERAN')
VistA.write('NO')
VistA.wait('SERVICE CONNECTED')
VistA.write('NO')
VistA.wait('MULTIPLE BIRTH INDICATOR')
VistA.write('')
VistA.wait('//')
VistA.write('^\r')
VistA.wait('MAIDEN NAME:')
VistA.write('')
VistA.wait('[CITY]')
VistA.write('Santa Monica')
VistA.wait('[STATE]')
VistA.write('California')
VistA.wait('ALIAS')
VistA.write('')
if VistA.type=='cache':
  # Enter in more information about the patient.
  VistA.wait('exit:')
  VistA.write('\r')
  VistA.wait('Patient Data')
  VistA.write('Y')
  VistA.wait('QUIT')
  VistA.write('4')
  VistA.wait('COUNTRY')
  VistA.write('')
  VistA.wait('STREET ADDRESS')
  VistA.write('834 Ocean Vista Avenue\r')
  VistA.wait('ZIP')
  VistA.write('90401')
  VistA.wait('CITY')
  VistA.write('1')
  VistA.wait('PHONE NUMBER')
  VistA.write('310-555-2233\r\r')
  VistA.wait('changes')
  VistA.write('Y\r')
  VistA.wait('QUIT')
  VistA.write('^2')
  VistA.wait('QUIT')
  VistA.write('3')
  VistA.wait('ETHNICITY')
  VistA.write('N')
  VistA.wait('RACE')
  VistA.write('B\rY\r')
  VistA.wait('QUIT')
  VistA.write('^3')
  VistA.wait('QUIT')
  VistA.write('1')
  VistA.wait('PRIMARY NOK')
  VistA.write('Carter,David J Sr')
  VistA.wait('RELATIONSHIP')
  VistA.write('FATHER')
  VistA.wait('ADDRESS')
  VistA.write('Y')
  VistA.wait('WORK PHONE')
  VistA.write('310-555-9876')
  VistA.wait('QUIT')
  VistA.write('^7')
  VistA.wait('QUIT')
  VistA.write('3')
  VistA.wait('PRIMARY ELIGIBILITY CODE')
  VistA.write('2\r\r\r\r')
  VistA.wait('QUIT')
  VistA.write('^')
  VistA.wait('condition')
  VistA.write('N')
  VistA.wait('today')
  VistA.write('Y\r')
else:
  # Workaround to reconnect after GT.M crash
  VistA=ConnectToMUMPS("C:/Users/contestant/OSEHRA/Dashboards/OSEHRA-Automated-Testing-build/Testing/Log/PostImport2.log","CACHE","CPM")
VistA.wait(PROMPT)
VistA.write('D ^ZU')
VistA.wait('ACCESS CODE:')
VistA.write('SM1234')
VistA.wait('VERIFY CODE:')
VistA.write('SM12345!!')
VistA.wait('//')
VistA.write('')


#Create the second patient named "David Carter Sr')
#TODO: Enter patient as a Clerk, not System Manager

VistA.wait('Menu Option:')
VistA.write('Register a Patient')
VistA.wait('PATIENT NAME')
VistA.write('Carter,David Sr\rY')
VistA.wait('SEX')
VistA.write('M')
VistA.wait('DATE OF BIRTH')
VistA.write('03/09/1943')
VistA.wait('SOCIAL SECURITY NUMBER')
VistA.write('000000111')
VistA.wait('TYPE')
VistA.write('SC VETERAN')
VistA.wait('PATIENT VETERAN')
VistA.write('Y')
VistA.wait('SERVICE CONNECTED')
VistA.write('Y')
VistA.wait('MULTIPLE BIRTH INDICATOR')
VistA.write('')
index = VistA.multiwait(['CARTER//','a new patient'])
if index == 1:
  VistA.write('Y')
  VistA.wait('CARTER//')
VistA.write('^\r')
VistA.wait('MAIDEN NAME:')
VistA.write('')
VistA.wait('[CITY]')
VistA.write('Santa Monica')
VistA.wait('[STATE]')
VistA.write('California')
VistA.wait('ALIAS')
VistA.write('')
if VistA.type=='cache':
  # Enter in more information about the patient.
  VistA.wait('exit:')
  VistA.write('\r')
  VistA.wait('Patient Data')
  VistA.write('Y')
  VistA.wait('QUIT')
  VistA.write('4')
  VistA.wait('COUNTRY')
  VistA.write('')
  VistA.wait('STREET ADDRESS')
  VistA.write('834 Ocean Vista Avenue\r')
  VistA.wait('ZIP')
  VistA.write('90401')
  VistA.wait('CITY')
  VistA.write('1')
  VistA.wait('PHONE NUMBER')
  VistA.write('310-555-2233\r\r')
  VistA.wait('changes')
  VistA.write('Y\r')
  VistA.wait('QUIT')
  VistA.write('^2')
  VistA.wait('QUIT')
  VistA.write('3')
  VistA.wait('ETHNICITY')
  VistA.write('N')
  VistA.wait('RACE')
  VistA.write('B\rY\r')
  VistA.wait('QUIT')
  VistA.write('^3')
  VistA.wait('QUIT')
  VistA.write('1')
  VistA.wait('PRIMARY NOK')
  VistA.write('Carter,David J Jr')
  VistA.wait('RELATIONSHIP')
  VistA.write('SON')
  VistA.wait('ADDRESS')
  VistA.write('Y')
  VistA.wait('WORK PHONE')
  VistA.write('310-555-9876')
  VistA.wait('QUIT')
  VistA.write('^7')
  VistA.wait('QUIT')
  VistA.write('3')
  VistA.wait('PRIMARY ELIGIBILITY CODE')
  VistA.write('3\r\r\r\r')
  VistA.wait('QUIT')
  VistA.write('^')
  VistA.wait('condition')
  VistA.write('N')
  VistA.wait('today')
  VistA.write('N\r')
else:
  # Workaround to reconnect after GT.M crash
  VistA=ConnectToMUMPS("C:/Users/contestant/OSEHRA/Dashboards/OSEHRA-Automated-Testing-build/Testing/Log/PostImport2.log","CACHE","CPM")
VistA.wait(PROMPT)
VistA.write('D ^ZU')
VistA.wait('ACCESS CODE:')
VistA.write('SM1234')
VistA.wait('VERIFY CODE:')
VistA.write('SM12345!!')
VistA.wait('//')
VistA.write('')
#Set Up the Quick Order Menu for the Strep Throat
VistA.wait('Menu Option:')
VistA.write('CPRS Configuration')
VistA.wait('Option:')
VistA.write('MM')
VistA.wait('Option:')
VistA.write('QO')
VistA.wait('Select QUICK ORDER NAME')
VistA.write('LRZ STREP TEST')
VistA.wait('Are you adding')
VistA.write('Y')
VistA.wait('TYPE OF QUICK ORDER')
VistA.write('LAB\r')
VistA.wait('DISPLAY TEXT')
VistA.write('STREP TEST')
VistA.wait('VERIFY ORDER')
VistA.write('Y')
VistA.wait('DESCRIPTION')
VistA.write('N\r')
VistA.wait('Lab Test')
VistA.write('STREP\r2')
VistA.wait('Collected By')
VistA.write('SP')
VistA.wait('Collection Sample')
VistA.write('SWAB\r')
VistA.wait('Collection Date/Time')
VistA.write('TODAY\r')
VistA.wait('How often')
VistA.write('ONCE')
VistA.wait('PLACE//')
VistA.write('\r\r')
VistA.wait('Option')
VistA.write('ST')
VistA.wait('Select ORDER SET NAME')
VistA.write('STREP TEST')
VistA.wait('Are you adding')
VistA.write('Y')
VistA.wait('Do you wish to copy')
VistA.write('No\r')
VistA.wait('DISPLAY TEXT')
VistA.write('Strep Test\r\r\r')
VistA.wait('COMPONENT SEQUENCE')
VistA.write('10\r')
VistA.wait('ITEM:')
VistA.write('LRZ STREP TEST\r\r\r\r')


#Add the Quick order for LRZ Strep to the Orders menu
VistA.wait('Menu Option:')
VistA.write('General Parameter')
VistA.wait('Select General Parameter Tools Option')
VistA.write('EP')
VistA.wait('Select PARAMETER DEFINITION NAME')
VistA.write('ORWOR WRITE ORDERS LIST')
VistA.wait('Enter selection')
VistA.write('3')
VistA.wait('Select Sequence')
VistA.write('10')
VistA.wait('Are you adding')
VistA.write('Y\r')
VistA.wait('Order Dialog')
VistA.write('STREP TEST\r2\r')
VistA.wait('selection:')
VistA.write('\r\r')

VistA.wait('Menu Option:')
VistA.write('CPRS Configuration')
VistA.wait('Option:')
VistA.write('MM')
VistA.wait('Option:')
VistA.write('MN')
VistA.wait('Select ORDER MENU')
VistA.write('OR ADD MENU CLINICIAN')
VistA.write('ADD\rMenu')
VistA.wait('ITEM')
VistA.write('STREP TEST\r2\r20\r1\r\r\r')
VistA.write('Q\r\r')

#Give all users of the instance permission to mark allergies as "Entered in error')
VistA.wait('Menu Option:')
VistA.write('CPRS Configuration')
VistA.wait('Option:')
VistA.write('GUI PARAMETERS')
VistA.wait('Option')
VistA.write('GUI Mark Allergy Entered in Error')
VistA.wait('Enter selection')
VistA.write('4\rY\r\r')


#Give Mary Smith permission to create shared templates

VistA.wait('Menu Option:')
VistA.write('TIU Maintenance')
VistA.wait('Option')
VistA.write('User Class Management')
VistA.wait('Option')
VistA.write('List Membership by User')
VistA.wait('Select USER')
VistA.write('MS\rAdd\rClinical Coordinator\rT-1\r\r\r')
VistA.wait('Option')
VistA.write('\r')


# Add the VHC clinic via the XUP menu to allow scheduling
VistA.wait('Menu Option:')
VistA.write('Core Applications')
VistA.wait('Core Applications Option')
VistA.write('Scheduling Manager')
VistA.wait('Menu Option')
VistA.write('Supervisor Menu')
VistA.wait('Supervisor Menu Option')
VistA.write('Set up a Clinic')
VistA.wait('Select CLINIC NAME')
VistA.write('VISTA HEALTH CARE')
VistA.wait('Are you adding')
VistA.write('Y')
VistA.wait('NAME')
VistA.write('')
VistA.wait('ABBREVIATION')
VistA.write('VHC')
VistA.wait('CLINIC MEETS')
VistA.write('Y')
VistA.wait('SERVICE')
VistA.write('M')
VistA.wait('NON-COUNT CLINIC')
VistA.write('N')
VistA.wait('STOP CODE NUMBER')
VistA.write('301\r\r')
VistA.wait('TELEPHONE')
VistA.write('555-555-1414\r\r\r\r\r\r\r\r\r\r\r')
VistA.wait('ALLOWABLE CONSECUTIVE NO-SHOWS')
VistA.write('0')
VistA.wait('FUTURE BOOKING')
VistA.write('90')
VistA.wait('HOUR CLINIC DISPLAY BEGINS')
VistA.write('8\r')
VistA.wait('AUTO-REBOOK')
VistA.write('90\r\r\r\r\r')
VistA.wait('MAXIMUM')
VistA.write('0\r')
VistA.wait('LENGTH OF APP')
VistA.write('30')
VistA.wait('VARIABLE')
VistA.write('Yes')
VistA.wait('DISPLAY INCREMENTS PER HOUR')
VistA.write('2')
dates = ['JUL 2,2012','JUL 3,2012','JUL 4,2012','JUL 5,2012','JUL 6,2012']
for date in dates:
  VistA.wait('AVAILABILITY DATE')
  VistA.write(date)
  VistA.wait('TIME')
  VistA.write('0800-1200\r4')
  VistA.wait('TIME')
  VistA.write('1230-1500\r4')
  VistA.wait('TIME')
  VistA.write('')
  VistA.wait('PATTERN OK')
  VistA.write('Yes')
VistA.wait('AVAILABILITY DATE')
VistA.write('\r\r\r\r')

# Add the VHC clinic via the XUP menu to allow scheduling
VistA.wait('Menu Option:')
VistA.write('Core Applications')
VistA.wait('Core Applications Option')
VistA.write('Scheduling Manager')
VistA.wait('Menu Option')
VistA.write('Supervisor Menu')
VistA.wait('Supervisor Menu Option')
VistA.write('Set up a Clinic')
VistA.wait('Select CLINIC NAME')
VistA.write('VISTA MEDICAL CENTER')
VistA.wait('Are you adding')
VistA.write('Y')
VistA.wait('NAME')
VistA.write('')
VistA.wait('ABBREVIATION')
VistA.write('VMC')
VistA.wait('CLINIC MEETS')
VistA.write('Y')
VistA.wait('SERVICE')
VistA.write('M')
VistA.wait('NON-COUNT CLINIC')
VistA.write('N')
VistA.wait('STOP CODE NUMBER')
VistA.write('301\r\r')
VistA.wait('TELEPHONE')
VistA.write('555-555-3636\r\r\r\r\r\r\r\r\r\r\r')
VistA.wait('ALLOWABLE CONSECUTIVE NO-SHOWS')
VistA.write('0')
VistA.wait('FUTURE BOOKING')
VistA.write('90')
VistA.wait('HOUR CLINIC DISPLAY BEGINS')
VistA.write('8\r')
VistA.wait('AUTO-REBOOK')
VistA.write('90\r\r\r\r\r')
VistA.wait('MAXIMUM')
VistA.write('0\r')
VistA.wait('LENGTH OF APP')
VistA.write('30')
VistA.wait('VARIABLE')
VistA.write('Yes')
VistA.wait('DISPLAY INCREMENTS PER HOUR')
VistA.write('2')
dates = ['JUL 2,2012','JUL 3,2012','JUL 4,2012','JUL 5,2012','JUL 6,2012']
for date in dates:
  VistA.wait('AVAILABILITY DATE')
  VistA.write(date)
  VistA.wait('TIME')
  VistA.write('0800-1200\r4')
  VistA.wait('TIME')
  VistA.write('1230-1500\r4')
  VistA.wait('TIME')
  VistA.write('')
  VistA.wait('PATTERN OK')
  VistA.write('Yes')
VistA.wait('AVAILABILITY DATE')
VistA.write('\r\r\r\r\r')
VistA.wait('Do you really want to halt?')
VistA.write('Y')

time.sleep(10)
#Set up the Doctors electronic signature
VistA=ConnectToMUMPS("C:/Users/contestant/OSEHRA/Dashboards/OSEHRA-Automated-Testing-build/Testing/Log/PostImportSignature.log","CACHE","CPM")
if ('' and ''):
  VistA.login('','')
if VistA.type=='cache':
  try:
    VistA.ZN('CPM')
  except IndexError,no_namechange:
    pass
VistA.wait(PROMPT)
VistA.write('D ^ZU')
VistA.wait('ACCESS CODE:')
VistA.write('fakedoc1')
VistA.wait('VERIFY CODE:')
VistA.write('2Doc!@#$')
VistA.wait('verify code:')
VistA.write('2Doc!@#$')
VistA.wait('VERIFY CODE:')
VistA.write('1Doc!@#$')
VistA.wait('right:')
VistA.write('1Doc!@#$')
VistA.wait('TYPE NAME')
VistA.write('')
VistA.wait('Option:')
VistA.write('USER\'s TOOLBOX')
VistA.wait('Toolbox Option')
VistA.write('ELE')
VistA.wait('INITIAL')
VistA.write('')
VistA.wait('SIGNATURE BLOCK PRINTED NAME')
VistA.write('')
VistA.wait('SIGNATURE BLOCK TITLE')
VistA.write('\r\r\r')
VistA.wait('SIGNATURE CODE')
VistA.write('ROBA123')
VistA.wait('SIGNATURE CODE FOR VERIFICATION')
VistA.write('ROBA123')
VistA.wait('Toolbox Option')
VistA.write('\r\r\r')
